function validarDados(evento)
 {
 let nomeCandidato = document.getElementById("nome").value;
 let valorSalario  = document.getElementById("salario-inicial").value;

 //acessando os dois labels que mostram erros de preenchimento do formulário
 let objErroNome = document.getElementById("erro-nome");
 let objErroSal  = document.getElementById("erro-salario");

 //vamos criar a variável de controle que indica se houve erros (ou não) na validação de campos do formulário
 let temErro = false;

 //deste ponto em diante, começa a validação propriamente dita. Para campos de texto, as duas validações mais comuns são: retirar espaços em branco inúteis e contar número de caracteres
 nomeCandidato = nomeCandidato.trim();
 valorSalario  = valorSalario.trim();

 //contando número de caracteres do nome do usuário
 if(nomeCandidato.length == 0)
  {
  temErro = true;
  objErroNome.innerHTML = "<span> Erro: nome inválido! </span>";
  }
 else
  {
  objErroNome.innerHTML = "";
  }

 //tratamento de campos numéricos de um formulário. A primeira coisa ser feita é converter a string numérica para número
 let salarioConvertidoParNumero = parseFloat(valorSalario);

 if(salarioConvertidoParNumero != valorSalario)
  {
  temErro = true;
  objErroSal.innerHTML = "<span> Erro: salário inválido </span>";
  }
 else
  {
  objErroSal.innerHTML = "";
  }

 //testamos se  houve erro no formulário. Se sim, o JS desativa o evento submit, impedindo o navegador de enviar os dados ao PHP no servidor
 if(temErro)
  {
  evento.preventDefault();
  }

 }

//acessando o formulário por meio do DOM
let objForm = document.getElementById("formulario");

//o evento correto que o JS usa para simular o envio de dados, por formulário, ao servidor, é o evento "submit", associado ao formulário
objForm.addEventListener("submit", validarDados);