function criarMatriz()
 {
 let objDiv = document.getElementById("conteiner");

 //acessar as caixas do formulário por meio do DOM
 const objProd1    = document.getElementById("nome1");
 const objEstoque1 = document.getElementById("estoque1");
 const objPreco1   = document.getElementById("preco1");

 const objProd2    = document.getElementById("nome2");
 const objEstoque2 = document.getElementById("estoque2");
 const objPreco2   = document.getElementById("preco2");

 const objProd3    = document.getElementById("nome3");
 const objEstoque3 = document.getElementById("estoque3");
 const objPreco3   = document.getElementById("preco3");

 //guardar os valores digitados em cada campo do formulário por meio dos objetos criados acima
 let prod1      = objProd1.value;
 let estoque1   = objEstoque1.value;
 let preco1     = objPreco1.value;

 let prod2      = objProd2.value;
 let estoque2   = objEstoque2.value;
 let preco2     = objPreco2.value;

 let prod3      = objProd3.value;
 let estoque3   = objEstoque3.value;
 let preco3     = objPreco3.value;

 //vamos criar os vetores parciais armazenando o estoque e o preço de cada produto
 let vetorProd1 = [estoque1, preco1];
 let vetorProd2 = [estoque2, preco2];
 let vetorProd3 = [estoque3, preco3];

 //finalmente, criamos a estrutura da matriz
 let matrizProd = [];
 matrizProd[prod1] = vetorProd1;
 matrizProd[prod2] = vetorProd2;
 matrizProd[prod3] = vetorProd3;

 console.log(matrizProd);

 //criar o cabeçalho da tabela HTML
 let cabecalhoTabela = "<table>\
                          <caption> Relação de produtos cadastrados na matriz </caption> \
                          <tr> \
                           <th> Produto </th>\
                           <th> Estoque </th> \
                           <th> Preço </th> \
                          </tr>";

 let corpoTabela = "";
 let produto, estoque, preco;

 for(produto  in matrizProd)
  {
  estoque = matrizProd[produto][0];
  preco   = matrizProd[produto][1];
  corpoTabela = corpoTabela + "<tr> <td>" + produto + "</td> <td>" + estoque + "</td> <td>" + preco + "</td> </tr>";
  }
 corpoTabela = corpoTabela + "</table>";

 //para calcular o valor total da venda de todos os produtos, vamos percorrer a matriz e multiplicar o preço de cada produto pela quantidade em estoque
 let soma = 0;

 for(produto in matrizProd)
  {
  estoque = matrizProd[produto][0];
  preco   = matrizProd[produto][1]
  soma = soma + estoque * preco;
  }

 soma = soma.toLocaleString("pt-BR", {style: "currency", currency: "BRL",  minimumFractionDigits: 2, maximumFractionDigits: 2});

 const msgVendaTotal = "<p> O faturamento com a venda de todos os produtos da matriz é igual a <span>" + soma + "</span> </p>";

 //descobrir os dados do produto mais barato guardado na matriz. Vamos supor que o primeiro produto já é o mais barato e vamos colocar seu preço na variável de controle
 let menorPreco = matrizProd[prod1][1];
 let nomeProdMaisBarato, estoqueProdMaisBarato;

 for(produto in matrizProd)
 {
  if(matrizProd[produto][1] <= menorPreco)
   {
   menorPreco = matrizProd[produto][1];
   estoqueProdMaisBarato = matrizProd[produto][0];
   nomeProdMaisBarato = produto;
   }
 }

 menorPreco = menorPreco.toLocaleString("pt-BR",
  {
  style: "currency",
  currency: "BRL",
  minimumFractionDigits: 2,
  maximumFractionDigits: 2
  }
 );

let msgDadosProdMaisBarato = "<p> Dados do produto mais barato cadastrado na matriz: <br>\
        Nome: <span>" + nomeProdMaisBarato + "</span> <br>\
        Estoque: <span>" + estoqueProdMaisBarato + " unidades </span> <br>\
        Preço: <span>" + menorPreco + "</span> </p>";


 objDiv.innerHTML = cabecalhoTabela + corpoTabela + msgVendaTotal + msgDadosProdMaisBarato;
}

let objBotao = document.getElementById("botao");
objBotao.addEventListener("click", criarMatriz);