function criarMatriz()
 {
 let objDiv = document.getElementById("conteiner");
 //criando a matriz em JS. Primeiramente, vamos definir 4 vetores temporários, que armazenam os dados de cada produto. São os vetores internos da matriz. Após isso, inserimos cada vetor dentro das células da matriz
 const vetorSom   = [20, 5, 520];
 const vetorVideo = [60, 5, 730];
 const vetorProcessador = [12, 10, 840.12];
 const vetorRam   = [10, 10, 376.14];

 //agora que já temos os vetores internos, criamos a matriz, cujo índice será o nome de cada produto e conterá, dentro de suas células, cada um dos vetores internos
 let matrizProdutos = [];

 matrizProdutos["Placa de Som"] = vetorSom;
 matrizProdutos["Placa de Vídeo"] = vetorVideo;
 matrizProdutos["Processador"] = vetorProcessador;
 matrizProdutos["Memória Ram"] = vetorRam;

 console.log(matrizProdutos);

 //criando a variável string que irá armazenar todos os resultados para serem exibidos na tag div
 let msgResposta = "<p> Produtos com estoque mínimo abaixo de 10 unidades: ";

 //percorrendo a matriz e descobrindo os produtos com estoque mínimo abaixo de 10 unidades
 let nomesProdutosAbaixo10 = '';

 //laço para peercorrer a matriz associativa
 let produto;
 for(produto in matrizProdutos)
  {
  if(matrizProdutos[produto][1] < 10)
   {
   nomesProdutosAbaixo10 = nomesProdutosAbaixo10 + " - " + produto;
   }  
  }

//antes de o JS escrever os nomes dos produtos, na página web, com estoque mínimo abaixo de 10 unidades, devemos testar se nenhum produto está nessa condição
if(!nomesProdutosAbaixo10)
   {
   nomesProdutosAbaixo10 = " - nenhum produto com estoque mínimo abaixo de 10 unidades.";
   }
//atualizar a mensagem de resposta
msgResposta = msgResposta + nomesProdutosAbaixo10 + "<br>";

//agora, vamos calcular o total faturado com a venda do estoque de todas as memórias RAM. Para isso, resolvemos o cálculo abaixo
let faturaRAM = matrizProdutos["Memória Ram"][0] * matrizProdutos["Memória Ram"][2];

//vamos aproveitar a oportunidade e aprender como o JavaScript formata valores monetários em reais
faturaRAM = faturaRAM.toLocaleString("pt-BR",
  {
  minimumFractionDigits: 2,
  maximumFractionDigits: 2
  }
);
msgResposta = msgResposta + "Valor total faturado com a venda de memória RAM: R$" + faturaRAM + "<br>";

//vamos calcular o valor total faturado com a venda de todos os produtos da matriz. Para isso, vamos utilizar o laço for para percorrer a matriz, multiplicando a quantidade em estoque pelo preço unitário
let faturaTotal = 0;

for(produto in matrizProdutos)
 {
 faturaTotal = faturaTotal + matrizProdutos[produto][0] * matrizProdutos[produto][2];
 }

faturaTotal = faturaTotal.toLocaleString("pt-BR",
  {
  minimumFractionDigits: 2,
  maximumFractionDigits: 2
  }
);

msgResposta = msgResposta + "Valor total faturado com a venda de todos os produtos cadastrados na matriz: R$" + faturaTotal + "<br>";

//vamos percorrer a matriz e descobrir o nome do produto mais caro cadastrado. Vamos inicializar a variável de controle com o preço do primeiro produto na matriz
let maiorPreco = matrizProdutos["Placa de Som"][2];
let nomeProdMaisCaro;

for(produto in matrizProdutos)
 {
 if(matrizProdutos[produto][2] > maiorPreco)
  {
  maiorPreco = matrizProdutos[produto][2];
  nomeProdMaisCaro = produto;
  }
 }

maiorPreco = maiorPreco.toLocaleString("pt-BR",
  {
  minimumFractionDigits: 2,
  maximumFractionDigits: 2
  }
);

msgResposta = msgResposta + "Nome do produto mais caro cadastrado na matriz: <span>" + nomeProdMaisCaro + "</span> <br> \
Preço do produto mais caro: <span> R$" + maiorPreco + "</span> </p>";

objDiv.innerHTML = msgResposta;
}

let objBotao = document.getElementById("botao");
objBotao.addEventListener("click", criarMatriz);