<!DOCTYPE html>
<html lang="pt-BR">
<head>
 <meta charset="UTF-8">
 <meta name="viewport" content="width=device-width, initial-scale=1.0">
 <title> Funções de usuário na linguagem PHP - subprogramação </title>
 <link rel="stylesheet" href="formata-form.css">
</head>

<body>
 <h1> Funções de usuário em PHP - exercício 4 </h1>
 
 <form method="post" action="exerc4.php">
  <fieldset>
   <legend> Lojas AAA - processamento de vendas </legend>

   <label class="alinha"> Informe o valor da compra: </label>
   <input type="number" name="valor-compra" step="0.01" min="0" autofocus> <br> <br>

   <label class="alinha"> Informe o percentual de comissão do vendedor: </label>
   <input type="number" name="percent-comissao" step="0.1" min="0"> <label>%</label> <br> <br>

   <input type="checkbox" name="fidelidade"> <label> Marque esta opção se o cliente está pagando com cartão de fidelidade da loja </label> <br>

   <button name="cadastrar"> Processar compra </button>
  </fieldset>
 </form>
 
 <?php
  function calcularComissao($valorCompra, $percentComissao)
   {
   $valorComissao = $valorCompra * $percentComissao/100;
   return $valorComissao;
   }

  //==============================================================================
  
  function calcularDesconto($valorCompra)
   {
   define("TAXA_DESC", 5/100);
   $desconto = 0;

   if(isset($_POST['fidelidade']))
    {
    $desconto = $valorCompra * TAXA_DESC;
    }
   return $desconto; 
   }

  //============================================================================
  
  function calcularValorFinalCompra($valorCompra, $valorDesconto)
   {
   $valorFinal = $valorCompra - $valorDesconto;
   return $valorFinal;
   }

  //============================================================================

  function mostrarResultados($valorCompra, $percentComissao, $valorComissao, $valorDesconto, $valorFinalCompra)
   {
   $valorCompra = number_format($valorCompra, 2, ",", ".");
   $percentComissao = number_format($percentComissao, 1, ",", ".");
   $valorComissao = number_format($valorComissao, 2, ",", ".");
   $valorDesconto = number_format($valorDesconto, 2, ",", ".");
   $valorFinalCompra = number_format($valorFinalCompra, 2, ",", ".");

   echo "<p> Resultados finais do processamento da compra: <br>
             Valor inicial da compra = <span> R$$valorCompra </span> <br>
             Percentual de comissão do vendedor = <span> {$percentComissao}% </span> <br>
             Valor da comissão do vendedor = <span> R$$valorComissao </span> <br>
             Valor do desconto do cliente = <span> R$$valorDesconto </span> <br>
             Valor final da compra = <span> R$$valorFinalCompra </span> </p>";
   }

  //==============================================================================

  if(isset($_POST["cadastrar"]))
   {
   $valorCompra = $_POST["valor-compra"];
   $percentComissao = $_POST['percent-comissao'];

   $valorComissao = calcularComissao($valorCompra, $percentComissao);

   $valorDesconto = calcularDesconto($valorCompra);

   $valorFinalCompra = calcularValorFinalCompra($valorCompra, $valorDesconto);

   mostrarResultados($valorCompra, $percentComissao, $valorComissao, $valorDesconto, $valorFinalCompra);
   }
 ?>
</body>
</html>