<!DOCTYPE html> 
<html lang="pt-BR"> 
<head> 
  <meta charset="utf-8"> 
  <title> Banco de dados com PHP  </title> 
  <link rel="stylesheet" href="../css/formata-banco.css">
</head> 

<body> 
  <h1> Integrando PHP com MySQL </h1>

  <form action="exercicio2.php" method="post">
   <fieldset>
    <legend> Dados cadastrais dos produtos </legend>

    <label class="alinha"> Código do produto: </label>
    <input type="text" name="codigo" autofocus placeholder="Forneça o id do produto"> <br>

    <label class="alinha"> Preço: </label>
    <input type="number" name="preco" min="0" step="0.01"> <br>

    <label class="alinha"> Quantidade em estoque: </label>
    <input type="number" name="estoque" min="0"> <br>

    <label class="alinha"> Selecione a classificação do produto: </label>

    <input type="radio" name="classific" value="Perecível"> <label> Produto perecível </label>

    <input type="radio" name="classific" value="Não-perecível"> <label> Produto não perecível </label> <br>

    <label class="alinha"> Descrição detalhada do produto: </label>
    <textarea name="descricao"></textarea> <br>

    <button name="cadastrar"> Cadastrar dados </button>
   </fieldset>

   <fieldset>
    <legend> Outras operações no banco de dados </legend>

    <label> Selecione a operação abaixo: </label>
    <select name="operacao">
      <option value="1"> Tabular dados dos produtos perecíveis </option>
      <option value="2"> Mostrar descrição do produto com menor quantidade em estoque </option>
      <option value="3"> Calcular faturamento da venda de não-perecíveis </option> 
    </select> <br> <br>

    <button name="outras-operacoes"> Executar operação selecionada </button>
   </fieldset>
  </form>
  
  <?php
   require "../includes/dados-conexao.inc.php";
   require "../includes/conectar.inc.php";
   require "../includes/criar-banco.inc.php";
   require "../includes/abrir-banco.inc.php";
   require "../includes/definir-charset.inc.php";
   require "../includes/criar-tabela.inc.php";

   if(isset($_POST['cadastrar']))
    {
    require "../includes/cadastrar.inc.php";
    }


   if(isset($_POST['outras-operacoes']))
    {
    //quando o PHP entra neste bloco lógico, devemos fazer com que ele receba o value do select associado à operação escolhida no formulário
    $operacao = $_POST['operacao'];

    if($operacao == "1")
     {
     require "../includes/tabular-dados.inc.php";
     }

    if($operacao == "2")
     {
     require "../includes/mostrar-descricao.inc.php";
     }

    if($operacao == "3")
     {
     require "../includes/calcular-faturamento.inc.php";
     }  
    }   
  require "../includes/desconectar.inc.php";  
  ?>
</body> 
</html> 