<?php
 $sql = "SELECT * FROM $nomeDaTabela WHERE classificacao = 'Perecível' ORDER BY estoque DESC";

 $resultado = $conexao->query($sql) or die($conexao->error);

 //sempre que formos tabular dados no formulário, antes, devemos solicitar para o PHP que nos diga quantos registros retornaram da consulta. Se não voltou, do banco, nenhum registro, enviamos uma mensagem apropriada ao cliente da aplicação. Se a consulta retornou, no mínimo, um registro, criamos o cabeçalho e o corpo da tabela normalmente
 $quantosRegistros = $conexao->affected_rows;
 if($quantosRegistros == 0)
  {
  //não há nenhum produto perecível cadastrado no banco de dados
  echo "<p> Caro usuário, não foi possível encontrar nenhum produto classificado como perecível no banco de dados. </p>";
  }
 else
  { 
  echo "<table> 
        <caption> Relação de <span> produtos perecíveis </span> cadastrados no banco de dados, ordenados decrescentemente pelo estoque </caption>
        <tr>
         <th> Código </th>
         <th> Preço </th>
         <th> Estoque </th>
         <th> Classificação </th>
         <th> Descrição </th>
        </tr>";

  while($vetorRegistro = $resultado->fetch_array())
   {
    $codigo     = $vetorRegistro[0];
    $preco      = $vetorRegistro[1];
    $estoque    = $vetorRegistro[2];
    $classific  = $vetorRegistro[3];
    $descricao  = $vetorRegistro[4];

    $codigo    = htmlentities($codigo, ENT_QUOTES, "UTF-8");
    $preco     = htmlentities($preco, ENT_QUOTES, "UTF-8");
    $estoque   = htmlentities($estoque, ENT_QUOTES, "UTF-8");
    $classific = htmlentities($classific, ENT_QUOTES, "UTF-8");
    $descricao = htmlentities($descricao, ENT_QUOTES, "UTF-8");

    $precoFormatado = number_format($preco, 2, ",", ".");

    echo "<tr>
           <td> $codigo </td>
           <td> $precoFormatado </td>
           <td> $estoque </td>
           <td> $classific </td>
           <td> $descricao </td>
        </tr>";
    }
  echo "</table>";
 }
