<?php
 //Esta include é responsável por descobrir o produto com a menor quantidade em estoque no banco de dados e mostrar sua descrição. Para resolvermos este problema, temos a possibilidade de seguirmos dois caminhos difentes, mostrados abaixo

 //CAMINHO 1 - nesta situação, vamos dividir o problema em duas consultas SQL separadas - primeiro passo: pedir ao Banco de Dados que encontre e devolva a menor quantidade em estoque cadastrada
 $sql1 = "SELECT MIN(estoque) FROM $nomeDaTabela";
 $resultado = $conexao->query($sql1) or die($conexao->error);

 $vetorRegistro = $resultado->fetch_array();
 $menorQuantEstoque = $vetorRegistro[0];

 //segundo passo: com a menor quantidade em estoque descoberta, criamos uma nova consulta SQL para que o banco de dados retorne o campo descrição do produto com a menor quantidade em estoque
 $sql2 = "SELECT descricao FROM $nomeDaTabela WHERE estoque = $menorQuantEstoque";
 $resultado = $conexao->query($sql2) or die($conexao->error);

 $vetorRegistro = $resultado->fetch_array();

 $descricao = $vetorRegistro[0];

 //evitar o ataque do tipo XSS
 $descricao = htmlentities($descricao, ENT_QUOTES, "UTF-8");

 echo "<p> Dados do produto com a menor quantidade em estoque no banco de dados: <br>
       Menor quantidade em estoque: <span> $menorQuantEstoque unidades </span> <br>
       Descrição = <span> $descricao </span> </p>";

//CAMINHO 2 - vamos resolver o mesmo problema, mas usando uma única consulta em PHP
$sql3 = "SELECT descricao FROM $nomeDaTabela WHERE estoque = (SELECT MIN(estoque) FROM $nomeDaTabela)";

$resultado = $conexao->query($sql3) or exit($conexao->error);

$vetorRegistro = $resultado->fetch_array();

$descricao = $vetorRegistro[0];

$descricao = htmlentities($descricao, ENT_QUOTES, "UTF-8");

 echo "<p> CAMINHO2 - A descrição do produto com a menor quantidade em estoque é <span> $descricao </span> </p>";

