<?php
 //esta include é responsável por solicitar, ao banco de dados, a relação de todos os alunos cadastrados (via SELECT) e exibir estes dados no formato tabular
 $sql = "SELECT * FROM $nomeDaTabela";

 //cuidado com a consulta SELECT. Sempre que ela for disparada, o PHP irá receber os dados de retorno do banco de dados. Estes dados recaem em um dos três grupos possíveis: a tabela inteira, parte da tabela ou um valor numérico inteiro. Para que isto seja possível, criamos um objeto de retorno (neste exemplo, o objeto $resultado). Através da manipulação deste objeto (como se fosse uma matriz do PHP), podemos recuperar os dados do aluno é mostrá-los no formato tabular

 $resultado = $conexao->query($sql) or die($conexao->error);

 //desenhando o cabeçalho da tabela na página web

 echo "<table> 
        <caption> Relação de alunos cadastrados no banco de dados </caption>
        <tr>
         <th> Matrícula </th>
         <th> Aluno </th>
         <th> Média em PRW </th>
        </tr>";

 //AVISO: sempre que usamos uma consulat SELECT, há a possibilidade de dispararmos um tipo de ataque conhecido como XSS. Para que impeçamos este problema, devemos usar o comando em PHP, listado abaixo

 while($vetorRegistro = $resultado->fetch_array())
  {
  $matric = $vetorRegistro[0];
  $aluno  = $vetorRegistro[1];
  $media  = $vetorRegistro[2];

  $matric = htmlentities($matric, ENT_QUOTES, "UTF-8");
  $aluno  = htmlentities($aluno, ENT_QUOTES, "UTF-8");
  $media  = htmlentities($media, ENT_QUOTES, "UTF-8");

  echo "<tr>
         <td> $matric </td>
         <td> $aluno </td>
         <td> $media </td>
        </tr>";
  }

 echo "</table>";
