<!DOCTYPE html> 
<html lang="pt-BR"> 
<head> 
  <meta charset="utf-8"> 
  <title> Modularização de código em PHP </title> 
  <link rel="stylesheet" href="formata-formulario.css">
</head> 

<body> 
 <h1> Funções de usuário em PHP - listaL4 - exercício 4 </h1>

 <form action="exercicio4.php" method="post">
  <fieldset>
   <legend> Lojas AAA - processamento de vendas </legend>

   <label class="alinha"> Forneça o valor inicial da compra: </label>
   <input type="number" name="valor-compra" step="0.01">  <br> 

   <label class="alinha"> Forneça o percentual comissão: </label>
   <input type="number" name="percentual-comissao" step="0.1">  <br> <br>

   <input type="checkbox" name="fidelidade"> <label> Marque esta opção se o pagamento foi efetudo com cartão de fidelidade </label> <br>
  </fieldset>

  <button name="enviar-dados"> Processar venda </button>
 </form>

 <?php

  if(isset($_POST['enviar-dados']))
   {
   $valorCompra = $_POST['valor-compra'];
   $percentComissao = $_POST['percentual-comissao'];

   //invocar a função que calcula o valor da comissão do vendedor
   $valorComissao = calcularValorComissao($valorCompra, $percentComissao);

   //invocar a função que calcular o valor do desconto dado ao cliente pela loja
   $valorDesconto = calcularValorDesconto($valorCompra);

   //calcular valor final da compra
   $valorFinalCompra = calcularValorCompra($valorCompra, $valorDesconto);

   //mostrar um resumo do processamento das vendas ao cliente da aplicação
   mostrarResultado($valorCompra, $percentComissao, $valorComissao, $valorDesconto, $valorFinalCompra);
   }  
 ?> 
</body> 
</html> 

<?php
 function calcularValorComissao($valorCompra, $percentComissao)
  {
  $comissao = $valorCompra * ($percentComissao/100);
  return $comissao;
  }

 //===========================================================================

 function calcularValorDesconto($valorCompra)
  {
  define("TAXA_DESCONTO", 5/100);

  $desconto = 0;

  $temDesconto = isset($_POST['fidelidade']);
   
  if($temDesconto)
   {
   $desconto = $valorCompra * TAXA_DESCONTO;
   }

  return $desconto;
  }

 //============================================================================

 function calcularValorCompra($valorCompra, $valorDesconto)
  {
  $valorFinalCompra = $valorCompra - $valorDesconto;
  return $valorFinalCompra;
  }

 //===========================================================================
 
 function mostrarResultado($valorCompra, $percentComissao, $valorComissao, $valorDesconto, $valorFinalCompra)
  {
  echo "<p> Resultado do processamento da compra: <br>
            Valor inicial da compra = <span> R$$valorCompra </span> <br>
            Percentual de comissão do vendedor = <span> $percentComissao% </span> <br>
            Valor da comissão do vendedor = <span> R$$valorComissao </span> <br>
            Valor do desconto do cliente = <span> R$$valorDesconto </span> <br>
            Valor final da compra = <span> R$$valorFinalCompra </span> </p>";
  }
?>
