//área de declaração das funções
function limparErroNome()
 {
 objErroNome.innerHTML = "";
 }

//===========================================================================

function limparErroSalario()
 {
 objErroSal.innerHTML = '';
 }

//==========================================================================

function validarDados(evento)
 {
 //acessando, por meio do JavaScript, as duas caixas do formulário
 var objNome = document.getElementById('nome');
 var objSalario = document.getElementById('salario-inicial');

 //agora, vamos criar duas variáveis para armazenarmos o que o usuário digitu dentro de cada caixa de texto no formulário
 var nomeDigitado = objNome.value;
 var valorSalarioDigitado = objSalario.value;

 //acessando os dois objeto label que mostram o erro, caso a validação falhe
 objErroNome = document.getElementById('erro-nome');
 objErroSal  = document.getElementById('erro-salario');

 var temErro = false; //controle de erros no formulário

 //aqui começa a validação de dados propriamente dita feito pelo JavaScript - retiramos os espaços em branco de dentro das duas variáveis que armazenam os dados do formulário
 var nome  = nomeDigitado.trim();
 var salario = valorSalarioDigitado.trim();

 //outra validação comum é testar se as caixa não ficaram vazias
 if(nome.length == 0)
  {
  temErro = true;
  objErroNome.innerHTML = "<span> Erro: caixa não pode estar vazia. </span>";
  }

 //a próxima validação é testar se aquilo que o usuário digitou no campo do salário é, de fato, uma string que pode ser convertida em um número
 var salarioConvertido = parseFloat(salario);

 //a única situação onde o conteúdo dentro da variável salarioConvertido é igual ao conteúdo dentro da variável salario (que trouxe o que o usuário digitou na caixa salario do formulário) é aquela onde o dado digitado pelo usuário é, de fato, um número válido
 if(salario != salarioConvertido)
  {
  temErro = true;
  objErroSal.innerHTML = "<span> Erro: este não é um número válido. </span>";
  } 

 //como fazer o JavaScript impedir o submit do formulário, se algum erro na validação foi detectado
 if(temErro)
  {
  evento.preventDefault();
  }

 //o que faremos abaixo é dizer ao JavaScript para limpar o texto de erro dos dois labels no formulário toda vez que o usuário clica em qualquer uma das duas caixas de dados
 objNome.addEventListener('click', limparErroNome);
 objSalario.addEventListener('click', limparErroSalario);
 }


/*Vamos declarar duas variáveis aqui. Elas serão usadas mais tarde.
O JavaScript oferece várias formas de se declarar uma variável*/
var objErroNome;
var objErroSal;

//acessando o formulário por meio do DOM
var objFormulario = document.getElementById("formulario");

//associar o evento de envio de dados do formulário (submit) ao servior, quqndo o usuário pressionar o botão submit. Aqui começa toda a tarefa de validação dos campos de dados pelo nosso código JavaScript

objFormulario.addEventListener("submit", validarDados);
