<!DOCTYPE html> 
<html lang="pt-BR"> 
<head> 
  <meta charset="utf-8"> 
  <title> Arquivos de usuário com PHP - exemplo2 </title> 
  <link rel="stylesheet" href="formata-banco.css">
</head> 

<body> 
  <h1> Arquivos de usuário com PHP - simulando um pequeno microblog </h1>

  <p> Publique, aqui, sua avaliação, seus comentários e suas impressões, bem como sugestões, a respeito do uso de nossa aplicação web. </p>

  <form action="arquivos.php" method="post">
   <fieldset>
    <legend> Cliente - informações básicas </legend>
    <label class="alinha"> Nome do cliente: </label> 
    <input type="text" name="cliente"> <br>

    <label class="alinha"> Sua mensagem: </label>
    <textarea name="mensagem"></textarea> <br>
    
    <button name="comentar"> Enviar comentário e visualizar mensagens </button>
   </fieldset>
  </form>

  <?php
   //o comando abaixo configura o PHP para, quando trabalhar com datas, independentemente de onde está situado geograficamente o servidor que executa a nossa aplicação web, sempre usar o fuso horário de nosso país
   date_default_timezone_set('America/Sao_Paulo');
   
   $nomeArquivo = "microblog.txt";

   if(isset($_POST['comentar']))
    {
    $nome     = $_POST['cliente'];
    $mensagem = str_replace("\n", "", $_POST["mensagem"]); //substitui a quebra de linha inserida no textarea pelo caractere nulo
    $data     = date("d/m/Y H:i:s");
   
    $linha = $nome . "-" . $mensagem . "-" . $data . PHP_EOL;

    file_put_contents($nomeArquivo, $linha, FILE_APPEND|LOCK_EX); 

    $vetorBlog = file($nomeArquivo);  
    //para que o navegador mostre os comentários no microblog, ordenados do mais recente para o mais antigo, basta invertermos os dados do vetor blog
    $vetorBlog = array_reverse($vetorBlog);
    print_r($vetorBlog);

    foreach($vetorBlog as $comentario)
     { 
     $comentario = htmlentities($comentario, ENT_QUOTES, "UTF-8");
     $vetorPartesComentario = explode("-", $comentario);
     echo "<p> Em $vetorPartesComentario[2] $vetorPartesComentario[0] escreveu: <br>
           <span> $vetorPartesComentario[1] </span> </p>";
     }
    }
  ?>    
</body> 
</html> 