<!DOCTYPE html> 
<html lang="pt-BR"> 
<head> 
  <meta charset="utf-8"> 
  <title> Arquivos de usuário com PHP </title> 
  <link rel="stylesheet" href="formata-banco.css">
</head> 

<body> 
  <h1> Arquivos de usuário com PHP </h1>

  <form action="arquivos.php" method="post">
   <fieldset>
    <legend> Alunos - cadastro </legend>
    <label class="alinha"> Nome: </label> 
    <input type="text" name="aluno"> <br>

    <label class="alinha"> Nota de PRW: </label>
    <input type="number" name="nota" step="0.1"> <br>
    
    <button name="cadastrar"> Cadastrar aluno </button>
   </fieldset>

   <button name="mostrar-dados"> Mostrar dados do arquivo </button>
   <button name="calcular-media"> Calcular média </button>
  </form>

  <?php
   $nomeArquivo = "arquivo-alunos.txt";

   if(isset($_POST['cadastrar']))
    {
    $aluno = $_POST['aluno'];
    $nota  = $_POST['nota'];

    $linha = $aluno . "-" . $nota . PHP_EOL;
    file_put_contents($nomeArquivo, $linha, FILE_APPEND|LOCK_EX); 
    
    echo "<p> Dados do aluno cadastrados com sucesso no arquivo de usuário. </p>";
    }

   if(isset($_POST['mostrar-dados']))
    {
    //vamos verificar se o arquivo de alunos já existe no servidor ou, se ele já existir, vamos testá-lo para descobrir se não está vazio
    if(!file_exists($nomeArquivo) OR filesize($nomeArquivo) == 0)
     {
     exit("<p> O arquivo $nomeArquivo não existe no servidor ou está vazio. </p>");
     }

    echo "<table> 
           <caption> Relação de alunos de PRW - nomes e notas </caption>
           <tr> 
            <th> Nome do aluno </th>
            <th> Nota de PRW </th>
           </tr>";

    $vetorLinhas = file($nomeArquivo);
    foreach($vetorLinhas as $ConteudoDoVetor)
     {
     $vetorDados = explode("-", $ConteudoDoVetor);

     echo "<tr>
            <td> $vetorDados[0] </td>
            <td> $vetorDados[1] </td>
           </tr>";
     }
    echo "</table>";
   }

  if(isset($_POST['calcular-media']))
   {
   if(!file_exists($nomeArquivo) OR filesize($nomeArquivo) == 0)
    {
    exit("<p> O arquivo $nomeArquivo não existe no servidor ou está vazio. </p>");
    } 

    $vetorLinhas = file($nomeArquivo);
    foreach($vetorLinhas as $ConteudoDoVetor)
     {
     $vetorDados = explode("-", $ConteudoDoVetor);
     //vamos criar um vetor auxiliar, contendo somente a nota de PRW de cada aluna
     $vetorNotas[] = $vetorDados[1];
     }

    //vamos usar as funções de vetores numéricos para calcularmos a média de todos os alunos em PRW
    $media = array_sum($vetorNotas)/count($vetorNotas);

    echo "<p> A média das notas de PRW calculada para toda a turma é igual a <span> $media </span> </p>";
   }
  ?>
    
</body> 
</html> 